<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Veritabanı bağlantı bilgileri
$host = '127.0.0.1';
$dbname = 'toskabet20_1';
$username = 'toskabet20_1';
$password = 'I7n]8LC*KvF#7Koc';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=$charset", $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => '500']);
    exit;
}

//file_put_contents(__DIR__ . '/callback_log.txt', date('Y-m-d H:i:s') . "\n" . file_get_contents('php://input') . "\n\n", FILE_APPEND);

// Gelen JSON verisini al
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Gerekli alanlar
$required = ['status', 'token', 'amount', 'userid', 'type', 'customer_transaction_id'];
foreach ($required as $field) {
    if (empty($data[$field])) {
        http_response_code(400);
        echo json_encode(['status' => '400']);
        exit;
    }
}

// Değişkenleri tanımla
$status           = $data['status'];
$token            = $data['token'];
$amount           = (float)$data['amount'];
$username         = $data['enduser_username'] ?? $data['username'] ?? null;
$userid           = $data['userid'];
$type             = $data['type'];
$transaction_id   = $data['customer_transaction_id'];
$reference        = $data['Reference'] ?? null;

// Username zorunlu mu? Eğer öyleyse kontrol edelim
if (empty($username)) {
    http_response_code(400);
    echo json_encode(['status' => '400', 'message' => 'Missing username or enduser_username']);
    exit;
}

// Logla
//$log_file = __DIR__ . '/api_logs.txt';
//file_put_contents($log_file, date('Y-m-d H:i:s') . " - " . print_r($data, true) . "\n", FILE_APPEND);

// Kullanıcıyı getir
$stmt = $pdo->prepare("SELECT users_balance, users_id, users_email, htag FROM users WHERE users_id = :users_id");
$stmt->bindParam(':users_id', $userid, PDO::PARAM_INT);
$stmt->execute();
$user = $stmt->fetch();

if (!$user) {
    http_response_code(404);
    echo json_encode(['status' => '404']);
    exit;
}

// İşlem tipi bazında ayrım yap
if ($type === 'deposit') {

    switch ($status) {
        case 'confirmed':
            // Kullanıcı bakiyesini artır
            $final_balance = $user['users_balance'] + $amount;
            $stmt = $pdo->prepare("UPDATE users SET users_balance = :final_balance WHERE users_id = :users_id");
            $stmt->execute([
                ':final_balance' => $final_balance,
                ':users_id' => $userid
            ]);

            // Affiliate komisyonu
            if (!empty($user['htag'])) {
                $stmt = $pdo->prepare("SELECT balance, comisyon FROM affiliate WHERE htag = :htag");
                $stmt->execute([':htag' => $user['htag']]);
                $affiliate = $stmt->fetch();

                if ($affiliate) {
                    $commission = $amount * ((float)$affiliate['comisyon'] / 100);
                    $new_balance = $affiliate['balance'] + $commission;

                    $stmt = $pdo->prepare("UPDATE affiliate SET balance = :balance WHERE htag = :htag");
                    $stmt->execute([':balance' => $new_balance, ':htag' => $user['htag']]);
                }
            }

            // Yatırım güncelle
            $stmt = $pdo->prepare("UPDATE investments SET final_balance = :final_balance, status = '1' WHERE investments_no = :investments_no");
            $stmt->execute([
                ':final_balance' => $final_balance,
                ':investments_no' => $transaction_id
            ]);

            // Bonus durumu sıfırla
            $pdo->prepare("UPDATE users SET bonus_status_yatirim = '0' WHERE users_id = :users_id")
                ->execute([':users_id' => $userid]);

            // Toplam yatırım logu
            $stmt = $pdo->prepare("INSERT INTO transaction_logs (type, total_amount) 
                    VALUES ('investment', :amount) 
                    ON DUPLICATE KEY UPDATE total_amount = total_amount + VALUES(total_amount)");
            $stmt->execute([':amount' => $amount]);

            http_response_code(200);
            echo json_encode(['status' => '200']);
            break;

        case 'declined':
            // Eğer deposit için declined işlemi varsa, onu ekleyebilirsin.
            // Örnek:
            // Burada yatırım işlemi reddedilmiş olabilir.
            // Duruma göre işlem yap.
            http_response_code(200);
            echo json_encode(['status' => '200']);
            break;

        default:
            http_response_code(400);
            echo json_encode(['status' => '400']);
            break;
    }

} elseif ($type === 'withdraw') {

    switch ($status) {
        case 'completed':
            // Çekim ödendi
            $stmt = $pdo->prepare("UPDATE users_witdraw SET status = '1', note_detai = 'Çekim ödendi' WHERE uw_cimlik = :uw_cimlik");
            $stmt->execute([':uw_cimlik' => $transaction_id]);

            // Toplam çekim logu
            $stmt = $pdo->prepare("INSERT INTO transaction_logs (type, total_amount)
                VALUES ('withdrawal', :amount)
                ON DUPLICATE KEY UPDATE total_amount = total_amount - VALUES(total_amount)");
            $stmt->execute([':amount' => $amount]);

            // Affiliate komisyonu düşür
            if (!empty($user['htag'])) {
                $stmt = $pdo->prepare("SELECT balance, comisyon FROM affiliate WHERE htag = :htag");
                $stmt->execute([':htag' => $user['htag']]);
                $affiliate = $stmt->fetch();

                if ($affiliate) {
                    $commission = $amount * ((float)$affiliate['comisyon'] / 100);
                    $new_balance = $affiliate['balance'] - $commission;

                    $stmt = $pdo->prepare("UPDATE affiliate SET balance = :balance WHERE htag = :htag");
                    $stmt->execute([':balance' => $new_balance, ':htag' => $user['htag']]);
                }
            }

            // Bonus durumu sıfırla
            $pdo->prepare("UPDATE users SET bonus_status_yatirim = '0' WHERE users_id = :users_id")
                ->execute([':users_id' => $userid]);

            http_response_code(200);
            echo json_encode(['status' => '200']);
            break;

        case 'declined':
            // Çekim iptal edildi
            $stmt = $pdo->prepare("UPDATE users_witdraw SET status = '2', note_detai = 'Çekim iptal edildi' WHERE uw_cimlik = :uw_cimlik");
            $stmt->execute([':uw_cimlik' => $transaction_id]);

            // Kullanıcı bakiyesine tutarı iade et
            $new_balance = $user['users_balance'] + $amount;
            $stmt = $pdo->prepare("UPDATE users SET users_balance = :balance WHERE users_id = :users_id");
            $stmt->execute([':balance' => $new_balance, ':users_id' => $userid]);

            http_response_code(200);
            echo json_encode(['status' => '200']);
            break;

        case 'canceled':
            // Çekim reddedildi
            $stmt = $pdo->prepare("UPDATE users_witdraw SET status = '2', note_detai = 'Reddedildi' WHERE uw_cimlik = :uw_cimlik");
            $stmt->execute([':uw_cimlik' => $transaction_id]);

            // Kullanıcı bakiyesine tutarı iade et
            $new_balance = $user['users_balance'] + $amount;
            $stmt = $pdo->prepare("UPDATE users SET users_balance = :users_balance WHERE users_id = :users_id");
            $stmt->execute([':users_balance' => $new_balance, ':users_id' => $userid]);
            
            
            $stmt = $pdo->prepare("INSERT INTO transaction_logs (type, total_amount) 
        VALUES ('withdrawal', :amount1) 
        ON DUPLICATE KEY UPDATE total_amount = total_amount - :amount2");
$stmt->execute([':amount1' => $amount, ':amount2' => $amount]);



            // Affiliate iade
            if (!empty($user['htag'])) {
                $stmt = $pdo->prepare("SELECT balance, comisyon FROM affiliate WHERE htag = :htag");
                $stmt->execute([':htag' => $user['htag']]);
                $affiliate = $stmt->fetch();

                if ($affiliate) {
                    $commission = $amount * ((float)$affiliate['comisyon'] / 100);
                    $new_balance = $affiliate['balance'] + $commission;

                    $stmt = $pdo->prepare("UPDATE affiliate SET balance = :balance WHERE htag = :htag");
                    $stmt->execute([':balance' => $new_balance, ':htag' => $user['htag']]);
                }
            }

            http_response_code(200);
            echo json_encode(['status' => '200']);
            break;

        default:
            http_response_code(400);
            echo json_encode(['status' => '400']);
            break;
    }

} else {
    http_response_code(400);
    echo json_encode(['status' => '400']);
}
?>
